using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;

using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgOverrideComment
	/// </summary>
	public class DlgOverrideComment : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Data.DataTable _dtComments;
		private bool _detailsRequired = false;
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.GroupBox grpComment;
		private System.Windows.Forms.Label lblMessage;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbComment;
		private System.Windows.Forms.TextBox txtComment;
		private System.Windows.Forms.Label lblDetails;
		private System.Windows.Forms.GroupBox grpIcon;
		private System.Windows.Forms.PictureBox picWarning;
		private System.Windows.Forms.Label lblComment;
        private PictureBox picComment;
        private PictureBox picContainer;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgOverrideComment()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			//
			this.btnOK.EnabledButton = false;
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="title"></param>
		/// <param name="message"></param>
		/// <param name="cannnedCommentContext"></param>
		public DlgOverrideComment(string title, string message, string cannnedCommentContext) : this()
		{
			this.Message = message;
			this.Title = title;
			this.LoadComments(cannnedCommentContext);
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="title"></param>
		/// <param name="message"></param>
		/// <param name="cannedCommentContext"></param>
		/// <param name="helpFile"></param>
		public DlgOverrideComment(string title, string message, string cannedCommentContext, string helpFile) : this(title, message, cannedCommentContext)
		{
			this.hlphelpChm.SetHelpKeyword(this, helpFile);
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.hlphelpChm.SetShowHelp(this, true);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(DlgOverrideComment));
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.grpComment = new System.Windows.Forms.GroupBox();
            this.lblMessage = new System.Windows.Forms.Label();
            this.cmbComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblComment = new System.Windows.Forms.Label();
            this.txtComment = new System.Windows.Forms.TextBox();
            this.lblDetails = new System.Windows.Forms.Label();
            this.grpIcon = new System.Windows.Forms.GroupBox();
            this.picContainer = new System.Windows.Forms.PictureBox();
            this.picComment = new System.Windows.Forms.PictureBox();
            this.picWarning = new System.Windows.Forms.PictureBox();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpComment.SuspendLayout();
            this.grpIcon.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picContainer)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.picComment)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.picWarning)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(344, 30);
            this.vbecsLogo1.TabIndex = 3;
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 254);
            this.lblRequiredField.TabIndex = 5;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(266, 241);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 2;
            this.btnCancel.Text = "&Cancel";
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnOK.EnabledButton = false;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = null;
            this.btnOK.Location = new System.Drawing.Point(186, 241);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 1;
            this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
            // 
            // grpComment
            // 
            this.grpComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpComment.Controls.Add(this.lblMessage);
            this.grpComment.Controls.Add(this.cmbComment);
            this.grpComment.Controls.Add(this.lblComment);
            this.grpComment.Controls.Add(this.txtComment);
            this.grpComment.Controls.Add(this.lblDetails);
            this.grpComment.Location = new System.Drawing.Point(60, 28);
            this.grpComment.Name = "grpComment";
            this.grpComment.Size = new System.Drawing.Size(282, 209);
            this.grpComment.TabIndex = 0;
            this.grpComment.TabStop = false;
            // 
            // lblMessage
            // 
            this.lblMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblMessage.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblMessage.Location = new System.Drawing.Point(8, 12);
            this.lblMessage.Name = "lblMessage";
            this.lblMessage.Size = new System.Drawing.Size(266, 68);
            this.lblMessage.TabIndex = 0;
            this.lblMessage.Text = "Set Message property to display here";
            this.lblMessage.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // cmbComment
            // 
            this.cmbComment.AccessibleDescription = "Comment";
            this.cmbComment.AccessibleName = "Comment";
            this.cmbComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbComment.Interval = 100;
            this.cmbComment.Location = new System.Drawing.Point(68, 88);
            this.cmbComment.MaxLength = 80;
            this.cmbComment.Name = "cmbComment";
            this.cmbComment.Size = new System.Drawing.Size(198, 22);
            this.cmbComment.TabIndex = 2;
            this.cmbComment.SelectedIndexChanged += new System.EventHandler(this.cmbComment_SelectedIndexChanged);
            this.cmbComment.TextChanged += new System.EventHandler(this.cmbComment_SelectedIndexChanged);
            // 
            // lblComment
            // 
            this.lblComment.Location = new System.Drawing.Point(8, 88);
            this.lblComment.Name = "lblComment";
            this.lblComment.Size = new System.Drawing.Size(60, 20);
            this.lblComment.TabIndex = 1;
            this.lblComment.Text = "Comment*";
            this.lblComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtComment
            // 
            this.txtComment.AcceptsReturn = true;
            this.txtComment.AccessibleDescription = "Details";
            this.txtComment.AccessibleName = "Details";
            this.txtComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtComment.Location = new System.Drawing.Point(68, 112);
            this.txtComment.MaxLength = 255;
            this.txtComment.Multiline = true;
            this.txtComment.Name = "txtComment";
            this.txtComment.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
            this.txtComment.Size = new System.Drawing.Size(198, 84);
            this.txtComment.TabIndex = 3;
            this.txtComment.TextChanged += new System.EventHandler(this.txtComment_TextChanged);
            // 
            // lblDetails
            // 
            this.lblDetails.Location = new System.Drawing.Point(8, 112);
            this.lblDetails.Name = "lblDetails";
            this.lblDetails.Size = new System.Drawing.Size(60, 20);
            this.lblDetails.TabIndex = 3;
            this.lblDetails.Text = "Details";
            this.lblDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpIcon
            // 
            this.grpIcon.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpIcon.Controls.Add(this.picContainer);
            this.grpIcon.Controls.Add(this.picComment);
            this.grpIcon.Controls.Add(this.picWarning);
            this.grpIcon.Location = new System.Drawing.Point(4, 28);
            this.grpIcon.Name = "grpIcon";
            this.grpIcon.Size = new System.Drawing.Size(52, 209);
            this.grpIcon.TabIndex = 4;
            this.grpIcon.TabStop = false;
            // 
            // picContainer
            // 
            this.picContainer.Image = ((System.Drawing.Image)(resources.GetObject("picContainer.Image")));
            this.picContainer.Location = new System.Drawing.Point(3, 8);
            this.picContainer.Name = "picContainer";
            this.picContainer.Size = new System.Drawing.Size(45, 45);
            this.picContainer.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picContainer.TabIndex = 2;
            this.picContainer.TabStop = false;
            // 
            // picComment
            // 
            this.picComment.Image = ((System.Drawing.Image)(resources.GetObject("picComment.Image")));
            this.picComment.Location = new System.Drawing.Point(3, 59);
            this.picComment.Name = "picComment";
            this.picComment.Size = new System.Drawing.Size(47, 47);
            this.picComment.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picComment.TabIndex = 1;
            this.picComment.TabStop = false;
            this.picComment.Visible = false;
            // 
            // picWarning
            // 
            this.picWarning.Image = ((System.Drawing.Image)(resources.GetObject("picWarning.Image")));
            this.picWarning.Location = new System.Drawing.Point(3, 109);
            this.picWarning.Name = "picWarning";
            this.picWarning.Size = new System.Drawing.Size(45, 45);
            this.picWarning.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picWarning.TabIndex = 0;
            this.picWarning.TabStop = false;
            this.picWarning.Visible = false;
            // 
            // DlgOverrideComment
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(344, 268);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnOK);
            this.Controls.Add(this.grpComment);
            this.Controls.Add(this.grpIcon);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.MinimumSize = new System.Drawing.Size(350, 250);
            this.Name = "DlgOverrideComment";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Set Title property to display here";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgOverrideComment_KeyDownSpeakMessage);
            this.Load += new System.EventHandler(this.DlgOverrideComment_Load);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.grpIcon, 0);
            this.Controls.SetChildIndex(this.grpComment, 0);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpComment.ResumeLayout(false);
            this.grpComment.PerformLayout();
            this.grpIcon.ResumeLayout(false);
            this.grpIcon.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picContainer)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.picComment)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.picWarning)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

        /// <summary>
        /// Type of image that can be set on the left side
        /// </summary>
        public enum CommentImageType
        {
            /// <summary>
            /// Override Warning image
            /// </summary>
            Warning = 0,
            /// <summary>
            /// Comment image
            /// </summary>
            Comment = 1
        }

        private CommentImageType _commentImageType = CommentImageType.Warning;

        /// <summary>
        /// Set the left side image
        /// </summary>
        /// <param name="imageType"></param>
        public void SetPicutureImage(CommentImageType imageType)
        {
            _commentImageType = imageType;

            if (imageType == CommentImageType.Warning)
            {
                picContainer.Image = picWarning.Image;
            }
            else if (imageType == CommentImageType.Comment)
            {
                picContainer.Image = picComment.Image;
            }
            else
            {
                picContainer.Image = null;
            }            
        }

		/// <summary>
		/// Get/Set Message
		/// </summary>
		public string Message
		{
			get
			{
				return this.lblMessage.Text;
			}
			set
			{
				this.lblMessage.Text = value;
			}
		}

		/// <summary>
		/// Get/Set Title
		/// </summary>
		public string Title
		{
			get
			{
				return this.vbecsLogo1.Title;
			}
			set
			{
				this.vbecsLogo1.Title = value;
				this.Text = "VBECS - "+value;
			}
		}

		/// <summary>
		/// Returns the comments from the Comment combo box appended to any text in the 
		/// Details test box
		/// </summary>
		public string Comment
		{
			get
			{
				string comment = "";
				if (this.cmbComment.SelectedIndex>-1)
				{
					if (this.cmbComment.Text.Trim().ToUpper() != "OTHER")
					{
						comment	= this.cmbComment.Text;
					}
					if (this.txtComment.Text.Trim().Length>0)
					{
						if ((comment.Length>0) && (comment[comment.Length-1] != '.'))
						{
							comment = comment + ". ";
						}
						comment = comment + this.txtComment.Text;
					}
				}
				return comment;
			}
		}

		/// <summary>
		/// Returns the Canned Comment GUID
		/// </summary>
		public Guid CannedCommentGuid
		{
			get
			{
				if (this.cmbComment.SelectedIndex>-1)
				{
					return (Guid)_dtComments.Rows[this.cmbComment.SelectedIndex][Common.VbecsTables.CannedComment.CannedCommentGuid];
				}
				return Guid.Empty;
			}	
		}

		/// <summary>
		/// Returns text from the Details text box
		/// </summary>
		public string Details
		{
			get
			{
				return this.txtComment.Text;
			}
		}

		/// <summary>
		/// LoadComments
		/// </summary> 
		/// <param name="cannedCommentContext"></param>
		public void LoadComments(string cannedCommentContext)
		{
			_dtComments = BOL.CannedComment.GetCannedComments(cannedCommentContext);
			//
			this.cmbComment.Items.Clear();
			foreach(System.Data.DataRow drComment in _dtComments.Rows)
			{
				this.cmbComment.Items.Add(drComment[Common.VbecsTables.CannedComment.CannedCommentText].ToString());
			}
			this.grpComment.AccessibleDescription = lblMessage.Text;
			this.grpComment.AccessibleName = lblMessage.Text;
		
		}

		private void CheckValid()
		{
			if (_detailsRequired)
			{
				btnOK.EnabledButton = (this.txtComment.Text.Trim().Length>0);
			}
			else
			{
				btnOK.EnabledButton = (this.cmbComment.SelectedIndex>-1);
			}
		}

		private void cmbComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.CheckIfDetailsRequired();
			//
			this.CheckValid();
		}

		private void CheckIfDetailsRequired()
		{
			//Details required if Comment = Other
			if (this.cmbComment.Text.Trim().ToUpper() == "OTHER")
			{
				this.lblDetails.Text = "Details*";
				this._detailsRequired = true;
			}
			else
			{
				this.lblDetails.Text = "Details";
				this._detailsRequired = false;
			}
		}

		private void txtComment_TextChanged(object sender, System.EventArgs e)
		{
			this.CheckIfDetailsRequired();
			//
			this.CheckValid();
		}

		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			if (this.btnOK.EnabledButton)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
			else
			{
				if (_detailsRequired)
				{
					this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.CommentRequiredWithOther().ResString);
				}
				else
				{
					this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.EnterAComment().ResString);
				}
			}
		}
		
		private void DlgOverrideComment_Load(object sender, System.EventArgs e)
		{
            // Only beep when displaying a warning/exception override
            if (_commentImageType == CommentImageType.Warning)
            {
                Common.Utility.MessageBeep();
            }
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgOverrideComment_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			if (!this.btnOK.EnabledButton)
			{
				if (_detailsRequired)
				{
					textToSpeak = Common.StrRes.Tooltips.Common.CommentRequiredWithOther().ResString;
				}
				else
				{
					textToSpeak = Common.StrRes.Tooltips.Common.EnterAComment().ResString;
				}
			}
			//
			this.SpeakMessage( textToSpeak );
		}

	}
}

